# Contributing to JustFans

Thank you for your interest in contributing to JustFans! This document provides guidelines and information for contributors.

## Code of Conduct

This project and everyone participating in it is governed by our Code of Conduct. By participating, you are expected to uphold this code.

## How to Contribute

### Reporting Issues

- Use the GitHub issue tracker to report bugs or request features
- Search existing issues before creating a new one
- Provide detailed information about the issue, including:
  - Steps to reproduce
  - Expected vs actual behavior
  - Environment details (PHP version, Laravel version, etc.)
  - Screenshots if applicable

### Contributing Code

1. **Fork the repository** on GitHub
2. **Clone your fork** locally:
   ```bash
   git clone https://github.com/your-username/justfans.git
   cd justfans
   ```
3. **Create a new branch** for your feature or bugfix:
   ```bash
   git checkout -b feature/your-feature-name
   ```
4. **Make your changes** following our coding standards
5. **Test your changes** thoroughly
6. **Commit your changes** with a clear commit message
7. **Push to your fork** and create a Pull Request

### Coding Standards

- Follow PSR-12 coding standards for PHP
- Use meaningful variable and function names
- Add comments for complex logic
- Write tests for new features
- Ensure all existing tests pass

### Pull Request Guidelines

- Provide a clear description of what your PR does
- Reference any related issues
- Ensure your code follows our coding standards
- Add tests for new functionality
- Update documentation if needed

## Development Setup

### Requirements

- PHP 8.0.2+
- MySQL/MariaDB 5.7+
- Node.js and npm
- Composer

### Installation

1. Clone the repository
2. Install PHP dependencies:
   ```bash
   composer install
   ```
3. Install Node.js dependencies:
   ```bash
   npm install
   ```
4. Copy environment file:
   ```bash
   cp .env.example .env
   ```
5. Generate application key:
   ```bash
   php artisan key:generate
   ```
6. Run migrations:
   ```bash
   php artisan migrate
   ```
7. Seed the database:
   ```bash
   php artisan db:seed
   ```

## Testing

- Run PHP tests: `php artisan test`
- Run frontend tests: `npm test`
- Check code style: `./vendor/bin/php-cs-fixer fix --dry-run`

## Documentation

- Update README.md for significant changes
- Add inline documentation for complex functions
- Update API documentation if applicable

## Security

- Do not commit sensitive information (API keys, passwords, etc.)
- Report security vulnerabilities privately to the maintainers
- Follow security best practices in your code

## Questions?

If you have questions about contributing, please:
- Open an issue on GitHub
- Join our community discussions
- Check existing documentation

Thank you for contributing to JustFans!
