# JustFans Documentation

## Table of Contents

1. [Overview](#overview)
2. [Features](#features)
3. [Installation](#installation)
4. [Configuration](#configuration)
5. [Usage](#usage)
6. [API Documentation](#api-documentation)
7. [Customization](#customization)
8. [Deployment](#deployment)
9. [Troubleshooting](#troubleshooting)
10. [Contributing](#contributing)

## Overview

JustFans is an open source Laravel-based platform that enables content creators to monetize their content through subscriptions, tips, and pay-per-view posts. It's designed to be a complete solution for creator economy businesses.

### Key Benefits

- **Open Source**: Free to use, modify, and distribute
- **Modern Stack**: Built with Laravel 10, PHP 8.0+, and modern web technologies
- **Scalable**: Designed to handle growth from startup to enterprise
- **Secure**: Built-in security features and best practices
- **Customizable**: Extensive customization options
- **Multi-language**: Internationalization support
- **Mobile-first**: Responsive design for all devices

## Features

### For Content Creators

- **Profile Management**: Customizable profiles with pricing tiers
- **Content Upload**: Support for images, videos, and text posts
- **Live Streaming**: Built-in live streaming capabilities
- **Subscription Management**: Multiple subscription tiers and pricing
- **Earnings Tracking**: Comprehensive earnings and analytics
- **Withdrawal System**: Multiple withdrawal methods
- **Identity Verification**: Built-in verification system
- **Content Scheduling**: Schedule posts for future release
- **Poll System**: Interactive polls for audience engagement

### For Fans/Subscribers

- **Subscription Management**: Easy subscription and cancellation
- **Content Consumption**: Access to exclusive content
- **Messaging System**: Private messaging with creators
- **Bookmarking**: Save favorite content
- **Lists**: Organize followed creators
- **Search**: Find content and creators
- **Notifications**: Real-time notifications
- **Mobile App**: PWA support for mobile experience

### For Administrators

- **User Management**: Comprehensive user administration
- **Content Moderation**: Review and approve content
- **Payment Processing**: Monitor transactions and payments
- **Analytics**: Detailed platform analytics
- **Settings Management**: Configure platform settings
- **Support System**: Handle user support requests

### Technical Features

- **Payment Gateways**: Stripe, PayPal, Coinbase, and more
- **Real-time Features**: Live chat, notifications, and updates
- **File Storage**: Local and cloud storage options
- **Video Processing**: FFmpeg integration for video processing
- **Image Processing**: Automatic image optimization
- **Caching**: Redis and file-based caching
- **Queue System**: Background job processing
- **API**: RESTful API for integrations
- **Webhooks**: Event-driven integrations

## Installation

### System Requirements

- PHP 8.0.2 or higher
- MySQL 5.7+ or MariaDB 10.2+
- Apache with mod_rewrite or Nginx
- Node.js 16+ and npm
- Composer
- At least 2GB RAM for development

### Quick Installation

1. **Clone the repository**
   ```bash
   git clone https://github.com/justfans/justfans.git
   cd justfans
   ```

2. **Install PHP dependencies**
   ```bash
   composer install
   ```

3. **Install Node.js dependencies**
   ```bash
   npm install
   ```

4. **Environment setup**
   ```bash
   cp .env.example .env
   php artisan key:generate
   ```

5. **Database setup**
   ```bash
   php artisan migrate
   php artisan db:seed
   ```

6. **Build assets**
   ```bash
   npm run prod
   ```

7. **Create admin user**
   ```bash
   php artisan make-admin admin@example.com
   ```

### Detailed Installation

See the [Installation Guide](INSTALLATION.md) for detailed installation instructions including server configuration, SSL setup, and production deployment.

## Configuration

### Environment Variables

Key environment variables to configure:

```env
APP_NAME="JustFans"
APP_ENV=production
APP_DEBUG=false
APP_URL=https://yourdomain.com

DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=justfans
DB_USERNAME=your_username
DB_PASSWORD=your_password

MAIL_MAILER=smtp
MAIL_HOST=your_smtp_host
MAIL_PORT=587
MAIL_USERNAME=your_email
MAIL_PASSWORD=your_password

PUSHER_APP_ID=your_pusher_id
PUSHER_APP_KEY=your_pusher_key
PUSHER_APP_SECRET=your_pusher_secret

STRIPE_KEY=your_stripe_key
STRIPE_SECRET=your_stripe_secret
```

### Payment Gateway Setup

#### Stripe
1. Create a Stripe account
2. Get your API keys from the Stripe dashboard
3. Add keys to your `.env` file
4. Set up webhooks in Stripe dashboard
5. Add webhook secret to admin settings

#### PayPal
1. Create a PayPal developer account
2. Create a new application
3. Get Client ID and Secret
4. Add to admin settings

### File Storage

Configure file storage in `config/filesystems.php`:

```php
'disks' => [
    'public' => [
        'driver' => 'local',
        'root' => storage_path('app/public'),
        'url' => env('APP_URL').'/storage',
        'visibility' => 'public',
    ],
    
    's3' => [
        'driver' => 's3',
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION'),
        'bucket' => env('AWS_BUCKET'),
        'url' => env('AWS_URL'),
    ],
],
```

## Usage

### Admin Panel

Access the admin panel at `/admin` with your admin credentials.

#### Key Admin Functions

1. **User Management**
   - View and manage users
   - Approve/reject user verification
   - Handle user reports

2. **Content Moderation**
   - Review pending posts
   - Approve/reject content
   - Manage content categories

3. **Payment Management**
   - Monitor transactions
   - Handle withdrawals
   - Manage payment settings

4. **Platform Settings**
   - Configure site settings
   - Manage payment gateways
   - Set up email templates

### User Management

#### Creating Content

1. **Posts**
   - Create text, image, or video posts
   - Set pricing for pay-per-view content
   - Schedule posts for future release
   - Add polls to posts

2. **Live Streaming**
   - Start live streams
   - Set stream pricing
   - Manage stream settings

3. **Subscriptions**
   - Set subscription prices
   - Create subscription tiers
   - Manage subscriber benefits

#### Managing Earnings

1. **View Earnings**
   - Track subscription revenue
   - Monitor tip income
   - View pay-per-view sales

2. **Withdrawals**
   - Request withdrawals
   - Set up payment methods
   - Track withdrawal status

## API Documentation

JustFans provides a comprehensive REST API for integrations.

### Authentication

Use API tokens for authentication:

```bash
curl -H "Authorization: Bearer YOUR_API_TOKEN" \
     -H "Accept: application/json" \
     https://yourdomain.com/api/users
```

### Key Endpoints

#### Users
- `GET /api/users` - List users
- `GET /api/users/{id}` - Get user details
- `POST /api/users` - Create user
- `PUT /api/users/{id}` - Update user

#### Posts
- `GET /api/posts` - List posts
- `GET /api/posts/{id}` - Get post details
- `POST /api/posts` - Create post
- `PUT /api/posts/{id}` - Update post

#### Subscriptions
- `GET /api/subscriptions` - List subscriptions
- `POST /api/subscriptions` - Create subscription
- `DELETE /api/subscriptions/{id}` - Cancel subscription

### Webhooks

JustFans supports webhooks for real-time event notifications:

- `user.created` - New user registration
- `post.created` - New post created
- `subscription.created` - New subscription
- `payment.completed` - Payment completed

## Customization

### Themes

Customize the appearance by modifying:

- `resources/views/` - Blade templates
- `resources/sass/` - SCSS stylesheets
- `public/css/` - Compiled CSS

### Adding Features

1. **Create Models**
   ```bash
   php artisan make:model YourModel
   ```

2. **Create Controllers**
   ```bash
   php artisan make:controller YourController
   ```

3. **Create Migrations**
   ```bash
   php artisan make:migration create_your_table
   ```

4. **Add Routes**
   ```php
   Route::get('/your-route', [YourController::class, 'method']);
   ```

### Custom Payment Gateways

1. Create a new payment provider class
2. Implement the required interface
3. Add configuration options
4. Register the provider

## Deployment

### Production Deployment

1. **Server Setup**
   - Use a VPS or dedicated server
   - Install PHP 8.0+, MySQL, and Nginx
   - Set up SSL certificates

2. **Application Deployment**
   ```bash
   git clone https://github.com/justfans/justfans.git
   cd justfans
   composer install --optimize-autoloader --no-dev
   npm run prod
   php artisan config:cache
   php artisan route:cache
   php artisan view:cache
   ```

3. **Queue Workers**
   ```bash
   php artisan queue:work --daemon
   ```

4. **Cron Jobs**
   ```bash
   * * * * * cd /path/to/justfans && php artisan schedule:run >> /dev/null 2>&1
   ```

### Docker Deployment

Use the provided Docker configuration for easy deployment:

```bash
docker-compose up -d
```

## Troubleshooting

### Common Issues

1. **Installation Issues**
   - Check PHP version compatibility
   - Verify database connection
   - Ensure proper file permissions

2. **Payment Issues**
   - Verify payment gateway configuration
   - Check webhook URLs
   - Review payment logs

3. **Performance Issues**
   - Enable caching
   - Optimize database queries
   - Use CDN for static assets

### Getting Help

- Check the [GitHub Issues](https://github.com/justfans/justfans/issues)
- Join our community discussions
- Review the documentation
- Contact support

## Contributing

We welcome contributions! Please see [CONTRIBUTING.md](CONTRIBUTING.md) for details.

### Development Setup

1. Fork the repository
2. Clone your fork
3. Create a feature branch
4. Make your changes
5. Add tests
6. Submit a pull request

### Code Standards

- Follow PSR-12 coding standards
- Write comprehensive tests
- Update documentation
- Use meaningful commit messages

---

For more information, visit our [GitHub repository](https://github.com/justfans/justfans) or join our community discussions.
