# Security Policy

## Supported Versions

We release patches for security vulnerabilities in the following versions:

| Version | Supported          |
| ------- | ------------------ |
| 1.0.x   | :white_check_mark: |
| < 1.0   | :x:                |

## Reporting a Vulnerability

We take security bugs seriously. We appreciate your efforts to responsibly disclose your findings, and will make every effort to acknowledge your contributions.

### How to Report

**Please do not report security vulnerabilities through public GitHub issues.**

Instead, please report them via email to: security@justfans.dev

You should receive a response within 48 hours. If for some reason you do not, please follow up via email to ensure we received your original message.

### What to Include

Please include the following information in your report:

- Type of issue (e.g. buffer overflow, SQL injection, cross-site scripting, etc.)
- Full paths of source file(s) related to the manifestation of the issue
- The location of the affected source code (tag/branch/commit or direct URL)
- Any special configuration required to reproduce the issue
- Step-by-step instructions to reproduce the issue
- Proof-of-concept or exploit code (if possible)
- Impact of the issue, including how an attacker might exploit it

### What to Expect

After you submit a report, we will:

1. Confirm receipt of your vulnerability report within 48 hours
2. Provide regular updates on our progress
3. Credit you in our security advisories (unless you prefer to remain anonymous)

## Security Best Practices

### For Developers

- Keep dependencies updated
- Use secure coding practices
- Implement proper input validation
- Use prepared statements for database queries
- Implement proper authentication and authorization
- Use HTTPS in production
- Keep sensitive data encrypted
- Implement rate limiting
- Use secure headers
- Regular security audits

### For Administrators

- Keep the application updated
- Use strong passwords
- Enable 2FA where possible
- Regular backups
- Monitor logs
- Use secure hosting
- Implement proper firewall rules
- Regular security scans
- Keep server software updated

## Security Features

JustFans includes several security features:

- **Authentication**: Secure user authentication with Laravel
- **Authorization**: Role-based access control with Spatie permissions
- **2FA**: Two-factor authentication support
- **Rate Limiting**: Built-in rate limiting for API endpoints
- **CSRF Protection**: Cross-site request forgery protection
- **XSS Protection**: Cross-site scripting protection
- **SQL Injection Protection**: Using Eloquent ORM and prepared statements
- **File Upload Security**: Secure file upload with validation
- **Content Security Policy**: CSP headers for additional security
- **Secure Headers**: Security headers implementation
- **Input Validation**: Comprehensive input validation
- **Output Encoding**: Proper output encoding to prevent XSS
- **Session Security**: Secure session management
- **Password Security**: Secure password hashing
- **API Security**: Secure API endpoints with proper authentication

## Disclosure Policy

When we receive a security bug report, we will:

1. Confirm the problem and determine the affected versions
2. Audit code to find any potential similar problems
3. Prepare fixes for all releases still under maintenance
4. Publish a security advisory

## Security Updates

Security updates will be released as soon as possible after a vulnerability is confirmed and fixed. We will:

- Release patches for supported versions
- Provide detailed information about the vulnerability
- Credit the reporter (unless they prefer to remain anonymous)
- Update this security policy if needed

## Contact

For security-related questions or concerns, please contact us at: security@justfans.dev

Thank you for helping keep JustFans and our users safe!
