<?php

namespace App\Filament\Pages\Settings;

use App\Filament\Traits\HasShieldPageAccess;
use App\Settings\LicenseSettings;
use Filament\Forms\Components\Placeholder;
use Filament\Forms\Components\Section;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use Illuminate\Support\HtmlString;

class ManageLicenseSettings extends SettingsPage
{
    use HasShieldPageAccess;

    protected static ?string $navigationIcon = 'heroicon-o-cog-6-tooth';

    protected static ?string $slug = 'settings/license';

    protected static ?string $title = 'About JustFans';

    protected static string $settings = LicenseSettings::class;

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make('Open Source Information')
                    ->description('JustFans is an open source creator economy platform.')
                    ->columns(1)
                    ->schema([
                        Placeholder::make('open_source_info')
                            ->label('')
                            ->content(new HtmlString(view('filament.partials.license')->render())),
                    ]),
            ]);
    }
}
