<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class UserBookmark extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id', 'post_id',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [

    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [

    ];

    /*
     * Relationships
     */

    public function user()
    {
        return $this->hasOne('App\Model\User', 'id', 'user_id');
    }

    public function post()
    {
        return $this->hasOne('App\Model\Post', 'id', 'post_id');
    }
}
