<?php $__env->startSection('page_title', __('Install the script')); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid installer-bg">
        <div class="row no-gutter d-flex justify-content-center align-items-center min-vh-100">
            <div class="col-4">
                <div class="d-flex justify-content-center pb-5">
                    <a href="<?php echo e(route('installer.install')); ?>">
                        <img class="brand-logo" src="<?php echo e(asset('/img/logo-black.png')); ?>">
                    </a>
                </div>
                <div class="col card shadow-sm">
                    <div class="card-body">
                        <div class="text-bold mb-2">
                            <?php echo e(__("Mandatory requirements")); ?>

                        </div>
                        <div class="row mb-1">
                            <div class="col-8"><?php echo e(__("PHP Version")); ?>: <?php echo e(phpversion()); ?></div>
                            <div class="col-4 d-flex justify-content-end">
                                <?php if(version_compare(phpversion(), '7.2.5') >= 0): ?>
                                    <?php echo $__env->make('elements.icon',['icon'=>'checkmark-circle-outline','variant'=>'medium', 'classes'=>'text-success'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php else: ?>
                                    <?php echo $__env->make('elements.icon',['icon'=>'close-circle-outline','variant'=>'medium', 'classes'=>'text-warning'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="row mb-1">
                            <div class="col-8">PHP allow_url_fopen</div>
                            <div class="col-4 d-flex justify-content-end ">
                                <?php if(ini_get('allow_url_fopen')): ?>
                                    <?php echo $__env->make('elements.icon',['icon'=>'checkmark-circle-outline','variant'=>'medium', 'classes'=>'text-success'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php else: ?>
                                    <?php echo $__env->make('elements.icon',['icon'=>'close-circle-outline','variant'=>'medium', 'classes'=>'text-danger'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php $__currentLoopData = $requiredExtensions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $PHPExtension): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="row mb-1">
                                <div class="col-8"><?php echo e($PHPExtension); ?></div>
                                <div class="col-4 d-flex justify-content-end">
                                    <?php if(extension_loaded($PHPExtension)): ?>
                                        <?php echo $__env->make('elements.icon',['icon'=>'checkmark-circle-outline','variant'=>'medium', 'classes'=>'text-success'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php else: ?>
                                        <?php echo $__env->make('elements.icon',['icon'=>'close-circle-outline','variant'=>'medium', 'classes'=>'text-danger'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <hr>
                        <div class="text-bold mb-2">
                            <?php echo e(__("Optional requirements")); ?>

                        </div>
                        <div class="row mb-1">
                            <div class="col-8">FFMpeg</div>
                            <div class="col-4 d-flex justify-content-end">
                                <div data-toggle="tooltip" data-placement="top" title="<?php echo e(__("FFMpeg paths are configured in admin panel. If not available, videos formats will fallback to mp4, uncompressed videos.")); ?>">
                                    <?php echo $__env->make('elements.icon',['icon'=>'information-circle-outline','variant'=>'medium', 'classes'=>'text-primary'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex flex-row-reverse">
                            <?php if($passesRequirements): ?>
                                <a href="<?php echo e(route('installer.install').'?step=2'); ?>" class="btn btn-primary mt-4"><?php echo e(__("Next")); ?></a>
                            <?php else: ?>
                                <span class="btn btn-primary mt-4 disabled"><?php echo e(__("Next")); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.install', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mexy/Downloads/JustFans/Script/resources/views/installer/requirements.blade.php ENDPATH**/ ?>