<?php
$course_settings = [
    'id'            => 'clear_course_amount_after_days',
    'type'          => 'number',
    'min'           => 0,
    'tab_id'        => 'lernen_general',
    'tab_title'     => __('settings.general'),
    'value'         => '',
    'class'         => '',
    'label_title'   => __('settings.clear_course_amount_after_days'),
    'placeholder'   => __('settings.enter_clear_course_amount_after_days'),
    'field_desc'    => __('settings.clear_course_amount_after_days_desc'),
];

$images_size = (int) (setting('_general.max_image_size') ?? '5');
$video_size = (int) (setting('_general.max_video_size') ?? '5');
$fields = [
    'section' => [
       'id'     => '_lernen',
       'label'  => __('settings.lernen_settings'),
       'tabs'   => true,
       'icon'   => '',
    ],
    'fields' => [
        [
            'id'            => 'payment_enabled',
            'type'          => 'select',
            'tab_id'        => 'lernen_general',
            'tab_title'     => __('settings.general'),
            'class'         => '',
            'label_title'   => __('settings.payment_enabled'),
            'options'       => [
                'yes'               => __('app.paid'),
                'no'                => __('app.free'),
            ],
            'default'       => 'yes',
            'field_desc'    => __('settings.payment_enabled_desc'),
            'placeholder'   => __('settings.select_from_list'),
        ],
        [
            'id'            => 'allow_register',
            'type'          => 'radio',
            'tab_id'        => 'lernen_general',
            'tab_title'     => __('settings.general'),
            'class'         => '',
            'label_title'   => __('admin/optionbuilder.allow_register'),
            'label_desc'    => '',
            'field_desc'    => '',
            'options'       => [
                'yes'   => __('admin/optionbuilder.yes'),
                'no'    => __('admin/optionbuilder.no'),
            ],
            'default'       => 'yes',
        ],
        [
            'id'            => 'allow_role_switching',
            'type'          => 'radio',
            'tab_id'        => 'lernen_general',
            'tab_title'     => __('settings.general'),
            'class'         => '',
            'label_title'   => __('admin/optionbuilder.allow_role_switching'),
            'label_desc'    => '',
            'field_desc'    => '',
            'options'       => [
                'yes'   => __('admin/optionbuilder.yes'),
                'no'    => __('admin/optionbuilder.no'),
            ],
            'default'       => 'yes',
        ],
        [
            'id'            => 'identity_verification_for_role',
            'type'          => 'radio',
            'tab_id'        => 'lernen_general',
            'tab_title'     => __('settings.general'),
            'class'         => '',
            'label_title'   => __('admin/optionbuilder.for_role'),
            'label_desc'    => '',
            'field_desc'    => '',
            'options'       => [
                'tutor'  => __('admin/optionbuilder.tutor_only'),
                'both' => __('admin/optionbuilder.both'),
            ],
            'default'       => 'both',
        ],
        [
            'id'            => 'profile_phone_number',
            'type'          => 'radio',
            'tab_id'        => 'lernen_general',
            'tab_title'     => __('settings.general'),
            'class'         => '',
            'label_title'   => __('admin/optionbuilder.profile_phone_number'),
            'label_desc'    => '',
            'field_desc'    => '',
            'options'       => [
                'yes'   => __('admin/optionbuilder.yes'),
                'no'    => __('admin/optionbuilder.no'),
            ],
            'default'       => 'yes',
        ],
        [
            'id'            => 'profile_keywords',
            'type'          => 'radio',
            'tab_id'        => 'lernen_general',
            'tab_title'     => __('settings.general'),
            'class'         => '',
            'label_title'   => __('settings.profile_keywords'),
            'label_desc'    => '',
            'field_desc'    => '',
            'options'       => [
                'yes'   => __('admin/optionbuilder.yes'),
                'no'    => __('admin/optionbuilder.no'),
            ],
            'default'       => 'yes',
        ],
        [
            'id'            => 'profile_video',
            'type'          => 'radio',
            'tab_id'        => 'lernen_general',
            'tab_title'     => __('settings.general'),
            'class'         => '',
            'label_title'   => __('admin/optionbuilder.profile_video'),
            'label_desc'    => '',
            'field_desc'    => '',
            'options'       => [
                'yes'  => __('admin/optionbuilder.yes'),
                'no'    => __('admin/optionbuilder.no'),
            ],
            'default'       => 'yes',
        ],
        [
            'id'            => 'time_format',
            'type'          => 'radio',
            'tab_id'        => 'lernen_general',
            'tab_title'     => __('settings.general'),
            'class'         => '',
            'label_title'   => __('admin/optionbuilder.time_format'),
            'label_desc'    => '',
            'field_desc'    => '',
            'options'       => [
                '12'  => __('admin/optionbuilder.12_hours'),
                '24'    => __('admin/optionbuilder.24_hours'),
            ],
            'default'       => '12',
        ],
        [
            'id'            => 'phone_number_on_signup',
            'type'          => 'radio',
            'tab_id'        => 'lernen_general',
            'tab_title'     => __('settings.general'),
            'class'         => '',
            'label_title'   => __('admin/optionbuilder.phone_number_on_signup'),
            'label_desc'    => '',
            'field_desc'    => '',
            'options'       => [
                'yes'  => __('admin/optionbuilder.yes'),
                'no' => __('admin/optionbuilder.no'),
            ],
            'default'       => 'yes',
        ],
        [
            'id'            => 'tutor_display_name',
            'type'          => 'text',
            'tab_id'        => 'lernen_general',
            'tab_title'     => __('settings.general'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('settings.tutor_display_name'),
            'placeholder'   => __('settings.enter_tutor_display_name'),
        ],
        [
            'id'            => 'student_display_name',
            'type'          => 'text',
            'tab_id'        => 'lernen_general',
            'tab_title'     => __('settings.general'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('settings.student_display_name'),
            'placeholder'   => __('settings.enter_student_display_name'),
        ],
        [
            'id'            => 'booking_reserved_time',
            'type'          => 'text',
            'tab_id'        => 'lernen_general',
            'tab_title'     => __('settings.general'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('settings.booking_reserved_time'),
            'placeholder'   => __('settings.enter_booking_reserved_time'),
        ],
        [
            'id'            => 'complete_booking_after_days',
            'type'          => 'text',
            'tab_id'        => 'lernen_general',
            'tab_title'     => __('settings.general'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('settings.mark_booking_completed_days'),
            'placeholder'   => __('settings.enter_mark_booking_completed_days'),
            'field_desc'    => __('settings.mark_booking_completed_days_desc'),
        ],
        [
            'id'            => 'start_of_week',
            'type'          => 'radio',
            'tab_id'        => 'lernen_general',
            'tab_title'     => __('settings.general'),
            'value'         => '0',
            'class'         => '',
            'options'       => [
                '0'     => __('calendar.sunday'),
                '1'     => __('calendar.monday'),
            ],
            'default'       => '0',
            'label_title'   => __('settings.start_of_week'),
        ],
        [
            'id'            => 'default_calendar_view',
            'type'          => 'select',
            'tab_id'        => 'lernen_general',
            'tab_title'     => __('settings.general'),
            'value'         => '0',
            'class'         => '',
            'options'       => [
                'daily'   => __('calendar.daily'),
                'weekly'  => __('calendar.weekly'),
                'monthly' => __('calendar.monthly'),
            ],
            'default'       => 'daily',
            'label_title'   => __('settings.default_calendar_view'),
        ],
        [
            'id'            => 'withdraw_amount_limit',
            'type'          => 'text',
            'tab_id'        => 'lernen_general',
            'tab_title'     => __('settings.general'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('settings.withdraw_amount_limit'),
            'placeholder'   => __('settings.enter_withdraw_amount_limit'),
            'field_desc'    => __('settings.withdraw_amount_limit_desc'),
        ],

        [
            'id'            => 'enable_help',
            'type'          => 'switch',
            'tab_id'        => 'help_to_find_tutors',
            'tab_title'     => __('settings.help_to_find_tutors'),
            'class'         => '',
            'label_title'   => __('settings.enable_help'),
            'value'       => '1',
        ],
        [
            'id'            => 'help_section_title',
            'type'          => 'text',
            'tab_id'        => 'help_to_find_tutors',
            'tab_title'     => __('settings.help_to_find_tutors'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('settings.help_section_title'),
            'placeholder'   => __('settings.enter_help_section_title'),
        ],
        [
            'id'            => 'help_section_description',
            'type'          => 'textarea',
            'tab_id'        => 'help_to_find_tutors',
            'tab_title'     => __('settings.help_to_find_tutors'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('settings.help_section_description'),
            'placeholder'   => __('settings.enter_help_section_description'),
        ],
        [
            'id'                => 'help_section_bullets',
            'type'              => 'repeater',
            'tab_id'            => 'help_to_find_tutors',
            'tab_title'         => __('settings.help_to_find_tutors'),
            'label_title'       => __('settings.help_section_bullets'),
            'repeater_title'    => __('settings.add_help_section_bullets'),
            'multi'       => true,
            'fields'       =>[
                [
                    'id'            => 'help_section',
                    'type'          => 'text',
                    'value'         => '',
                    'class'         => '',
                    'label_title'   => __('settings.add_help_section'),
                    'placeholder'   => __('settings.enter_help_section'),
                ],
            ]
        ],
        [
            'id'            => 'help_section_media',
            'type'          => 'file',
            'tab_id'        => 'help_to_find_tutors',
            'tab_title'     => __('settings.help_to_find_tutors'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('settings.help_section_media'),
            'placeholder'   => __('settings.add_help_section_media'),
            'max_size'   => $video_size,                  // size in MB
            'ext'    => [
                'mp4',
            ],
        ],
        [
            'id'            => 'enable_tips',
            'type'          => 'switch',
            'tab_id'        => 'tips_to_review',
            'tab_title'     => __('settings.tips_to_review'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('settings.enable_tips'),
            // 'field_desc'    => __('settings.add_enable_tips'),
            'value'       => '1',
        ],
        [
            'id'            => 'tip_section_title',
            'type'          => 'text',
            'tab_id'        => 'tips_to_review',
            'tab_title'     => __('settings.tips_to_review'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('settings.tips_section_heading'),
            'placeholder'   => __('settings.enter_tips_section_heading'),
        ],
        [
            'id'            => 'tip_section_description',
            'type'          => 'textarea',
            'tab_id'        => 'tips_to_review',
            'tab_title'     => __('settings.tips_to_review'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('settings.tips_section_description'),
            'placeholder'   => __('settings.enter_tips_section_description'),
        ],
        [
            'id'                => 'tip_bullets_repeater',
            'type'              => 'repeater',
            'tab_id'            => 'tips_to_review',
            'tab_title'         => __('settings.tips_to_review'),
            'label_title'       => __('settings.tip_bullets'),
            'repeater_title'    => __('settings.tip_bullets_repeater'),
            'multi'       => true,
            'fields'       =>[
                [
                    'id'            => 'tip_bullets',
                    'type'          => 'text',
                    'value'         => '',
                    'class'         => '',
                    'placeholder'   => __('settings.enter_tip_bullets'),
                ],
            ]
        ],
        [
            'id'            => 'enable_booking_tips',
            'type'          => 'switch',
            'tab_id'        => 'tips_for_booking',
            'tab_title'     => __('settings.tips_for_booking'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('settings.enable_tips'),
            'value'       => '1',
        ],
        [
            'id'            => 'tips_for_booking_image',
            'type'          => 'file',
            'tab_id'        => 'tips_for_booking',
            'tab_title'     => __('settings.tips_for_booking'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('settings.tips_for_booking_image'),
            'max_size'   => $images_size,                  // size in MB
            'ext'    => [
                'jpg',
                'png',
            ],
        ],
        [
            'id'            => 'tips_for_booking_heading',
            'type'          => 'text',
            'tab_id'        => 'tips_for_booking',
            'tab_title'     => __('settings.tips_for_booking'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('settings.tips_for_booking_heading'),
            'placeholder'   => __('settings.tips_for_booking_heading_placeholder'),
        ],

        [
            'id'                => 'tips_for_booking_bullets',
            'type'              => 'repeater',
            'tab_id'            => 'tips_for_booking',
            'tab_title'         => __('settings.tips_for_booking_bullets'),
            'label_title'       => __('settings.tips_for_booking_bullets'),
            'repeater_title'    => __('settings.add_bullets'),
            'multi'       => true,
            'fields'       =>[
                [
                    'id'            => 'tips_for_booking_bullet',
                    'type'          => 'text',
                    'value'         => '',
                    'class'         => '',
                    'label_title'   => __('settings.add_bullets'),
                    'placeholder'   => __('settings.add_bullets'),
                ],
            ]
        ],
        [
            'id'            => 'tips_for_booking_sub_heading',
            'type'          => 'text',
            'tab_id'        => 'tips_for_booking',
            'tab_title'     => __('settings.tips_for_booking'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('settings.tips_for_booking_sub_heading'),
            'placeholder'   => __('settings.enter_tips_section_sub_heading'),
        ],
        [
            'id'                => 'tips_for_booking_sub_bullets',
            'type'              => 'repeater',
            'tab_id'            => 'tips_for_booking',
            'tab_title'         => __('settings.tips_for_booking_sub_bullets'),
            'label_title'       => __('settings.tips_for_booking_sub_bullets'),
            'repeater_title'    => __('settings.add_bullets'),
            'multi'       => true,
            'fields'       =>[
                [
                    'id'            => 'tips_for_booking_sub_bullet',
                    'type'          => 'text',
                    'value'         => '',
                    'class'         => '',
                    'label_title'   => __('settings.add_bullets'),
                    'placeholder'   => __('settings.add_bullets'),
                ],
            ]
        ],
        [
            'id'            => 'well_wishing_text',
            'type'          => 'text',
            'tab_id'        => 'tips_to_review',
            'tab_title'     =>  __('settings.tips_to_review'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('settings.well_wishing_text'),
            'placeholder'   => __('settings.enter_well_wishing_text'),
        ],

        [
            'id'            => 'title',
            'type'          => 'text',
            'tab_id'        => 'above_footer_content',
            'tab_title'     => __('settings.above_footer_content'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('settings.title'),
            'placeholder'   => __('settings.enter_title'),
        ],
        [
            'id'            => 'description',
            'type'          => 'text',
            'tab_id'        => 'above_footer_content',
            'tab_title'     => __('settings.above_footer_content'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('settings.description'),
            'placeholder'   => __('settings.enter_description'),
        ],
        [
            'id'            => 'cta_text',
            'type'          => 'text',
            'tab_id'        => 'above_footer_content',
            'tab_title'     => __('settings.above_footer_content'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('settings.cta_text'),
            'placeholder'   => __('settings.enter_cta_text'),
        ],
        [
            'id'            => 'cta_url',
            'type'          => 'text',
            'tab_id'        => 'above_footer_content',
            'tab_title'     => __('settings.above_footer_content'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('settings.cta_url'),
            'placeholder'   => __('settings.enter_cta_url'),
        ],

        [
            'id'                => 'repeater_with_fields',
            'type'              => 'repeater',
            'tab_id'            => 'above_footer_content',
            'tab_title'         =>__('settings.above_footer_content'),
            'label_title'       => __('settings.fields'),
            'repeater_title'    => __('settings.add_fields'),
            'multi'       => true,
            'fields'       =>[
                [
                    'id'            => 'icon_class',
                    'type'          => 'text',
                    'value'         => '',
                    'class'         => '',
                    'label_title'   => __('settings.icon_class'),
                    'placeholder'   => __('settings.add_icon'),
                    'max_size'   => 3,                  // size in MB
                    'ext'    => [
                        'jpg',
                        'png',
                    ],
                ],
                [
                    'id'            => 'title',
                    'type'          => 'text',
                    'value'         => '',
                    'class'         => '',
                    'label_title'   => __('settings.fields_title'),
                    'placeholder'   => __('settings.enter_fields_title'),
                ],
                [
                    'id'            => 'description',
                    'type'          => 'text',
                    'value'         => '',
                    'class'         => '',
                    'label_title'   => __('settings.fields_description'),
                    'placeholder'   => __('settings.enter_fields_description'),
                ],
            ]
        ],
        [
            'id'            => 'restricting_tutor_account_creation',
            'type'          => 'radio',
            'tab_id'        => 'lernen_general',
            'tab_title'     => __('settings.general'),
            'class'         => '',
            'label_title'   => __('settings.restricting_tutor_account_creation'),
            'label_desc'    => '',
            'field_desc'    => '',
            'options'       => [
                'yes'  => __('admin/optionbuilder.yes'),
                'no' => __('admin/optionbuilder.no'),
            ],
            'default'       => 'no',
        ],
    ]
];

if(\Nwidart\Modules\Facades\Module::has('courses') && \Nwidart\Modules\Facades\Module::isEnabled('courses')){
    $fields['fields'][] = $course_settings;
}

if(\Nwidart\Modules\Facades\Module::has('subscriptions') && \Nwidart\Modules\Facades\Module::isEnabled('subscriptions')){
    $fields['fields'][] = [
        'id'            => 'subscription_sessions_allowed',
        'type'          => 'radio',
        'tab_id'        => 'lernen_general',
        'tab_title'     => __('settings.general'),
        'value'         => 'all',
        'class'         => '',
        'options'       => [
            'all'       => __('general.all'),
            'tutor'     => __('settings.tutor_specified'),
        ],
        'label_title'   => __('settings.allow_subscriptions_to_session'),
    ];
    $fields['fields'][] = [
        'id'            => 'notify_subscription_expiry_before_days',
        'type'          => 'number',
        'min'           => 0,
        'tab_id'        => 'lernen_general',
        'tab_title'     => __('settings.general'),
        'value'         => '0',
        'class'         => '',
        'label_title'   => __('settings.notify_subscription_expiry_before_days'),
        'placeholder'   => __('settings.add_expiry_days'),
        'field_desc'    => __('settings.notify_subscription_expiry_before_days_desc'),
    ];
}

return $fields;
