<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('user_subject_group_subjects', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_subject_group_id')->constrained();
            $table->foreignId('subject_id')->constrained();
            $table->float('hour_rate')->default(0);
            $table->text('description')->nullable();
            $table->string('image', 255)->nullable();
            $table->integer('sort_order')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::dropIfExists('user_subject_group_subjects');
    }
};
