<?php

$maxImageSize = setting('_general.max_image_size');

return [
    'id'        => 'banner-v6',
    'name'      => __('BannerV6'),
    'icon'      => '<i class="icon-credit-card"></i>',
    'tab'       => "Banners",
    'fields'    => [
        [
            'id'            => 'first_heading',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('First Heading'),
            'placeholder'   => __('Enter heading'),
        ],
        [
            'id'            => 'second_heading',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Second Heading'),
            'placeholder'   => __('Enter heading'),
        ],
        [
            'id'            => 'paragraph',
            'type'          => 'editor',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Description'),
            'placeholder'   => __('Enter description'),
        ],
        [
            'id'            => 'primary_btn_txt',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Primary button text'),
            'placeholder'   => __('Enter button text'),
        ],
        [
            'id'            => 'primary_btn_url',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Primary button url'),
            'placeholder'   => __('Enter button url'),
        ],
        [
            'id'            => 'secondary_btn_txt',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Secondary button Text'),
            'placeholder'   => __('Enter text'),
        ],
        [
            'id'            => 'secondary_btn_url',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Secondary button URL'),
            'placeholder'   => __('Enter url'),
        ],
        [
            'id'            => 'third_banner_image',
            'type'          => 'file',
            'class'         => '',
            'label_title'   => __('Shape Image'),
            'label_desc'    => __('Add image'),
            'max_size'      => $maxImageSize ?? 5,
            'ext'    => [
                'jpg',
                'png',
                'svg',
                'jpeg',
                'webp',
            ],
        ],
        [
            'id'            => 'banner_main_image',
            'type'          => 'file',
            'class'         => '',
            'label_title'   => __('Main Image'),
            'label_desc'    => __('Add image'),
            'max_size'      => $maxImageSize ?? 5,
            'ext'    => [
                'jpg',
                'png',
                'svg',
                'jpeg',
                'webp',
            ],
        ],
        [                                                          
            'id'                => 'image_repeater',
            'type'              => 'repeater',
            'label_title'       => __('User image'),
            'repeater_title'    => __('Image'),
            'multi'             => true,
            'fields'            => [
                [
                    'id'            => 'user_review_img',
                    'type'          => 'file',
                    'class'         => '',
                    'label_title'   => __('User Image'),
                    'label_desc'    => __('Add image'),
                    'max_size'      => $maxImageSize ?? 5,
                    'ext'    => [
                        'jpg',
                        'png',
                        'svg',
                        'jpeg',
                        'webp',
                    ],
                ],
            ]
        ],
        [
            'id'            => 'user_rating_text',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Users Reviews'),
            'placeholder'   => __('Enter Reviews Value'),
        ],
        [                                                          
            'id'                => 'rating_repeater',
            'type'              => 'repeater',
            'label_title'       => __('Rating image'),
            'repeater_title'    => __('Rating'),
            'multi'             => true,
            'fields'            => [
                [
                    'id'                => 'rating_icon',
                    'type'              => 'text',
                    'value'             => '',
                    'class'             => '',
                    'label_title'       => __('Add icon'),
                    'placeholder'       => __('<i class="fa-solid fa-arrow-up-right-from-square"></i>'),
                ],
            ]
        ],
        [
            'id'            => 'rating',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Ratings'),
            'placeholder'   => __('Enter Ratings Value'),
        ],
        [
            'id'            => 'rating_text',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Ratings Text'),
            'placeholder'   => __('Enter Ratings Text'),
        ],
        [
            'id'            => 'animated_first_image',
            'type'          => 'file',
            'class'         => '',
            'label_title'   => __('Rate experience image'),
            'label_desc'    => __('Add image'),
            'max_size'      => 1,
            'ext'    => [
                'jpg',
                'png',
                'svg',
            ],
        ],
        [
            'id'            => 'animated_second_image',
            'type'          => 'file',
            'class'         => '',
            'label_title'   => __('Animated image'),
            'label_desc'    => __('Add image'),
            'max_size'      => $maxImageSize ?? 5,
            'ext'    => [
                'jpg',
                'png',
                'svg',
                'jpeg',
                'webp',
            ],
        ],
        [
            'id'            => 'background_animated_first_image',
            'type'          => 'file',
            'class'         => '',
            'label_title'   => __('First shape image'),
            'label_desc'    => __('Add image'),
            'max_size'      => $maxImageSize ?? 5,
            'ext'    => [
                'jpg',
                'png',
                'svg',
                'jpeg',
                'webp',
            ],
        ],
        [
            'id'            => 'background_animated_second_image',
            'type'          => 'file',
            'class'         => '',
            'label_title'   => __('Second shape image'),
            'label_desc'    => __('Add image'),
            'max_size'      => $maxImageSize ?? 5,
            'ext'    => [
                'jpg',
                'png',
                'svg',
                'jpeg',
                'webp',
            ],
        ],
    ]
];

